"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableRow = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const Flowbite_1 = require("../Flowbite");
const TableContext_1 = require("./TableContext");
const TableRow = ({ children, className, theme: customTheme = {}, ...props }) => {
    const { hoverable, striped } = (0, TableContext_1.useTableContext)();
    const theme = (0, mergeDeep_1.mergeDeep)((0, Flowbite_1.useTheme)().theme.table.row, customTheme);
    return ((0, jsx_runtime_1.jsx)("tr", { "data-testid": "table-row-element", className: (0, classnames_1.default)(striped && theme.striped, hoverable && theme.hovered, className), ...props, children: children }));
};
exports.TableRow = TableRow;
