"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToastToggle = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const hi_1 = require("react-icons/hi");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const ToastContext_1 = require("./ToastContext");
const ToastToggle = ({ className, theme: customTheme = {}, xIcon: XIcon = hi_1.HiX, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.toast.toggle, customTheme);
    const { duration, isClosed, isRemoved, setIsClosed, setIsRemoved } = (0, ToastContext_1.useToastContext)();
    const handleClick = () => {
        setIsClosed(!isClosed);
        setTimeout(() => setIsRemoved(!isRemoved), duration);
    };
    return ((0, jsx_runtime_1.jsx)("button", { "aria-label": "Close", onClick: handleClick, type: "button", className: (0, classnames_1.default)(theme.base, className), ...props, children: (0, jsx_runtime_1.jsx)(XIcon, { "aria-hidden": true, className: theme.icon }) }));
};
exports.ToastToggle = ToastToggle;
