import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean, FlowbiteColors, FlowbiteSizes } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteBadgeTheme {
    root: FlowbiteBadgeRootTheme;
    icon: FlowbiteBadgeIconTheme;
}
export interface FlowbiteBadgeRootTheme {
    base: string;
    color: FlowbiteColors;
    href: string;
    size: BadgeSizes;
}
export interface FlowbiteBadgeIconTheme extends FlowbiteBoolean {
    size: BadgeSizes;
}
export interface BadgeSizes extends Pick<FlowbiteSizes, 'xs' | 'sm'> {
    [key: string]: string;
}
export interface BadgeProps extends PropsWithChildren<Omit<ComponentProps<'span'>, 'color'>> {
    color?: keyof FlowbiteColors;
    href?: string;
    icon?: FC<ComponentProps<'svg'>>;
    size?: keyof BadgeSizes;
    theme?: DeepPartial<FlowbiteBadgeTheme>;
}
export declare const Badge: FC<BadgeProps>;
