import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteCardTheme {
    root: FlowbiteCardRootTheme;
    img: FlowbiteCardImageTheme;
}
export interface FlowbiteCardRootTheme {
    base: string;
    children: string;
    horizontal: FlowbiteBoolean;
    href: string;
}
export interface FlowbiteCardImageTheme {
    base: string;
    horizontal: FlowbiteBoolean;
}
export interface CardProps extends PropsWithChildren<ComponentProps<'div'>> {
    horizontal?: boolean;
    href?: string;
    imgAlt?: string;
    imgSrc?: string;
    theme?: DeepPartial<FlowbiteCardTheme>;
}
export declare const Card: FC<CardProps>;
