import type { ComponentProps, ReactNode } from 'react';
import type { DeepPartial } from '..';
import type { TextInputColors, TextInputSizes } from '../TextInput';
export interface FlowbiteFileInputTheme {
    root: FlowbiteFileInputRootTheme;
    field: FlowbiteFileInputFieldTheme;
}
export interface FlowbiteFileInputRootTheme {
    base: string;
}
export interface FlowbiteFileInputFieldTheme {
    base: string;
    input: FlowbiteFileInputFieldInputTheme;
}
export interface FlowbiteFileInputFieldInputTheme {
    base: string;
    colors: TextInputColors;
    sizes: TextInputSizes;
}
export interface FileInputProps extends Omit<ComponentProps<'input'>, 'type' | 'ref' | 'color'> {
    color?: keyof TextInputColors;
    helperText?: ReactNode;
    sizing?: keyof TextInputSizes;
    theme?: DeepPartial<FlowbiteFileInputTheme>;
}
export declare const FileInput: import("react").ForwardRefExoticComponent<FileInputProps & import("react").RefAttributes<HTMLInputElement>>;
