import type { FC, ReactNode } from 'react';
import type { FlowbiteTheme } from './FlowbiteTheme';
export type Mode = 'light' | 'dark';
export interface ThemeContextProps {
    theme: FlowbiteTheme;
    mode?: Mode;
    toggleMode?: () => void | null;
}
export declare const ThemeContext: import("react").Context<ThemeContextProps>;
interface ThemeProviderProps {
    children: ReactNode;
    value: ThemeContextProps;
}
export declare const ThemeProvider: FC<ThemeProviderProps>;
export declare function useTheme(): ThemeContextProps;
export declare const useThemeMode: () => [Mode, React.Dispatch<React.SetStateAction<Mode>>, () => void];
export {};
