import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const NavbarBrand = ({ as: Component = 'a', children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.navbar.brand, customTheme);
    return (_jsx(Component, { className: classNames(theme.base, className), ...props, children: children }));
};
