import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const NavbarLink = ({ active, as: Component = 'a', disabled, children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.navbar.link, customTheme);
    return (_jsx("li", { children: _jsx(Component, { className: classNames(theme.base, {
                [theme.active.on]: active,
                [theme.active.off]: !active && !disabled,
            }, theme.disabled[disabled ? 'on' : 'off'], className), ...props, children: children }) }));
};
