import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
import { useSidebarContext } from './SidebarContext';
const SidebarCTA = ({ children, color = 'info', className, theme: customTheme = {}, ...props }) => {
    const { isCollapsed } = useSidebarContext();
    const theme = mergeDeep(useTheme().theme.sidebar.cta, customTheme);
    return (_jsx("div", { "data-testid": "sidebar-cta", hidden: isCollapsed, className: classNames(theme.base, theme.color[color], className), ...props, children: children }));
};
SidebarCTA.displayName = 'Sidebar.CTA';
export default SidebarCTA;
