import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import classNames from 'classnames';
import { useId } from 'react';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const ToggleSwitch = ({ checked, className, color = 'blue', disabled, label, name, onChange, theme: customTheme = {}, ...props }) => {
    const id = useId();
    const theme = mergeDeep(useTheme().theme.toggleSwitch, customTheme);
    const toggle = () => onChange(!checked);
    const handleClick = (event) => {
        event.preventDefault();
        toggle();
    };
    const handleKeyPress = (event) => {
        event.preventDefault();
    };
    return (_jsxs(_Fragment, { children: [name && checked && _jsx("input", { checked: checked, hidden: true, name: name, readOnly: true, type: "checkbox", className: "sr-only" }), _jsxs("button", { "aria-checked": checked, "aria-labelledby": `${id}-flowbite-toggleswitch-label`, disabled: disabled, id: `${id}-flowbite-toggleswitch`, onClick: handleClick, onKeyPress: handleKeyPress, role: "switch", tabIndex: 0, type: "button", className: classNames(theme.root.base, theme.root.active[disabled ? 'off' : 'on'], className), ...props, children: [_jsx("div", { "data-testid": "flowbite-toggleswitch-toggle", className: classNames(theme.toggle.base, theme.toggle.checked[checked ? 'on' : 'off'], !disabled && checked && theme.toggle.checked.color[color]) }), _jsx("span", { "data-testid": "flowbite-toggleswitch-label", id: `${id}-flowbite-toggleswitch-label`, className: theme.root.label, children: label })] })] }));
};
