export declare type Options = {
    /**
     * A validate callback that is called for each `locale`. If the `locale` is valid, return the `locale` as a string.
     * Otherwise return `undefined`, `null`, or an empty Array.
     * Should the callback throw an error, the error will be caught and the `locale` will be ignored.
     */
    validate?: (locale: string) => string | string[] | null | undefined;
    /**
     * If set to `true`, the wildcard locale `*` will be returned in the array.
     * If set to `false`, the wildcard locale `*` will be ignored.
     * Defaults to `true`.
     */
    ignoreWildcard?: boolean;
};
export declare const parseAcceptLanguage: (languageHeaderValue: string | null | undefined, options?: Options) => string[];
