import IMask from 'imask/esm/imask';
import { useRef, useState, useCallback, useEffect } from 'react';

function useIMask(opts, _temp) {
  let {
    onAccept,
    onComplete
  } = _temp === void 0 ? {} : _temp;
  const ref = useRef(null);
  const maskRef = useRef(null);
  const [initialized, setInitialized] = useState(false);
  const [lastAcceptState, setLastAcceptState] = useState({});
  const [value, setValue] = useState('');
  const [unmaskedValue, setUnmaskedValue] = useState('');
  const [typedValue, setTypedValue] = useState();
  const _destroyMask = useCallback(() => {
    var _maskRef$current;
    if (!initialized) return;
    (_maskRef$current = maskRef.current) == null ? void 0 : _maskRef$current.destroy();
    maskRef.current = null;
  }, []);
  const _onAccept = useCallback(event => {
    const m = maskRef.current;
    if (!m) return;
    setLastAcceptState({
      value: m.value,
      unmaskedValue: m.unmaskedValue,
      typedValue: m.typedValue
    });
    setTypedValue(m.typedValue);
    setUnmaskedValue(m.unmaskedValue);
    setValue(m.value);
    onAccept == null ? void 0 : onAccept(m.value, m, event);
  }, [onAccept]);
  const _onComplete = useCallback(() => maskRef.current && (onComplete == null ? void 0 : onComplete(maskRef.current.value, maskRef.current)), [onComplete]);
  useEffect(() => {
    const el = ref.current;
    if (!el || !(opts != null && opts.mask)) return _destroyMask();
    const mask = maskRef.current;
    if (!mask) {
      if (el && opts != null && opts.mask) {
        maskRef.current = IMask(el, opts);
        _onAccept();
      }
    } else {
      mask == null ? void 0 : mask.updateOptions(opts); // TODO fix no idea
    }

    setInitialized(Boolean(maskRef.current));
  }, [opts, _destroyMask, _onAccept]);
  useEffect(() => {
    if (!maskRef.current) return;
    const mask = maskRef.current;
    mask.on('accept', _onAccept);
    mask.on('complete', _onComplete);
    return () => {
      mask.off('accept', _onAccept);
      mask.off('complete', _onComplete);
    };
  }, [_onAccept, _onComplete]);
  useEffect(() => {
    const {
      value: lastAcceptValue,
      ...state
    } = lastAcceptState;
    const mask = maskRef.current;
    if (mask && initialized) {
      if (lastAcceptValue !== value) mask.value = value;
      setLastAcceptState(state);
    }
  }, [value]);
  useEffect(() => {
    const {
      unmaskedValue: lastAcceptUnmaskedValue,
      ...state
    } = lastAcceptState;
    const mask = maskRef.current;
    if (mask && initialized) {
      if (lastAcceptUnmaskedValue !== unmaskedValue) mask.unmaskedValue = unmaskedValue;
      setLastAcceptState(state);
    }
  }, [unmaskedValue]);
  useEffect(() => {
    const {
      typedValue: lastAcceptTypedValue,
      ...state
    } = lastAcceptState;
    const mask = maskRef.current;
    if (mask && initialized) {
      if (lastAcceptTypedValue !== typedValue) mask.typedValue = typedValue;
      setLastAcceptState(state);
    }
  }, [typedValue]);
  useEffect(() => _destroyMask, [_destroyMask]);
  return {
    ref,
    maskRef,
    value,
    setValue,
    unmaskedValue,
    setUnmaskedValue,
    typedValue,
    setTypedValue
  };
}

export { useIMask as default };
