import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import { createElement as _createElement } from "react";
import { useLocation, useMatches } from "@remix-run/react";
export function DynamicLinks() {
    let location = useLocation();
    let links = useMatches().flatMap((match, index, matches) => {
        var _a;
        let fn = (_a = match.handle) === null || _a === void 0 ? void 0 : _a.dynamicLinks;
        if (typeof fn !== "function")
            return [];
        let result = fn({
            id: match.id,
            data: match.data,
            params: match.params,
            location,
            parentsData: matches.slice(0, index).map((match) => match.data),
        });
        if (Array.isArray(result))
            return result;
        return [];
    });
    return (_jsx(_Fragment, { children: links.map((link) => (_createElement("link", { ...link, key: link.integrity || JSON.stringify(link) }))) }));
}
