/**
 * Check if a specific Request is a prefetch request created by using
 * <Link prefetch="intent"> or <Link prefetch="render">.
 *
 * @example
 * export async function loader({ request }: LoaderArgs) {
 *   let data = await getData(request)
 *   let headers = new Headers()
 *   if (isPrefetch(request)) {
 *     headers.set("Cache-Control", "private, max-age=5, smax-age=0")
 *   }
 *   return json(data, { headers })
 * }
 */
export declare function isPrefetch(request: Request): boolean;
export declare function isPrefetch(headers: Headers): boolean;
