import { EntryContext } from "@remix-run/server-runtime";
/**
 * Combine `preloadLinkedAssets` and `preloadModuleAssets` into a single
 * function and preload both linked and module assets.
 * @param context Remix's EntryContext
 * @param headers The headers object to append the preload links to
 * @example
 * export default function handleRequest(
 *   request: Request,
 *   statusCode: number,
 *   headers: Headers,
 *   context: EntryContext
 * ) {
 *   let markup = renderToString(
 *     <RemixServer context={context} url={request.url} />
 *   );
 *   headers.set("Content-Type", "text/html");
 *
 *   preloadRouteAssets(context, headers); // add this line
 *
 *   return new Response("<!DOCTYPE html>" + markup, {
 *     status: statusCode,
 *     headers: headers,
 *   });
 * }
 */
export declare function preloadRouteAssets(context: EntryContext, headers: Headers): void;
/**
 * Preload the assets linked in the routes matching the current request.
 * This function will preload any `<link rel="preload" />` tag added with
 * `LinksFunction` and any CSS files linked with `<link rel="stylesheet" />`.
 * @param context Remix's EntryContext
 * @param headers The headers object to append the preload links to
 * @example
 * export default function handleRequest(
 *   request: Request,
 *   statusCode: number,
 *   headers: Headers,
 *   context: EntryContext
 * ) {
 *   let markup = renderToString(
 *     <RemixServer context={context} url={request.url} />
 *   );
 *   headers.set("Content-Type", "text/html");
 *
 *   preloadLinkedAssets(context, headers); // add this line
 *
 *   return new Response("<!DOCTYPE html>" + markup, {
 *     status: statusCode,
 *     headers: headers,
 *   });
 * }
 */
export declare function preloadLinkedAssets(context: EntryContext, headers: Headers): void;
/**
 * Add Link headers to preload the JS modules in the route matching the current
 * request.
 * @param context Remix's EntryContext
 * @param headers The headers object to append the preload links to
 * @example
 * export default function handleRequest(
 *   request: Request,
 *   statusCode: number,
 *   headers: Headers,
 *   context: EntryContext
 * ) {
 *   let markup = renderToString(
 *     <RemixServer context={context} url={request.url} />
 *   );
 *   headers.set("Content-Type", "text/html");
 *
 *   preloadModuleAssets(context, headers); // add this line
 *
 *   return new Response("<!DOCTYPE html>" + markup, {
 *     status: statusCode,
 *     headers: headers,
 *   });
 * }
 */
export declare function preloadModuleAssets(context: EntryContext, headers: Headers): void;
