import { Cookie, CookieParseOptions, CookieSerializeOptions } from "@remix-run/server-runtime";
import type { z } from "zod";
export interface TypedCookie<Schema extends z.ZodTypeAny> extends Cookie {
    isTyped: true;
    parse(cookieHeader: string | null, options?: CookieParseOptions): Promise<z.infer<Schema> | null>;
    serialize(value: z.infer<Schema>, options?: CookieSerializeOptions): Promise<string>;
}
export declare function createTypedCookie<Schema extends z.ZodTypeAny>({ cookie, schema, }: {
    cookie: Cookie;
    schema: Schema;
}): TypedCookie<Schema>;
/**
 * Returns true if an object is a Remix Utils Typed Cookie container.
 *
 * @see https://github.com/sergiodxa/remix-utils#typed-cookies
 */
export declare function isTypedCookie<Schema extends z.ZodTypeAny>(value: unknown): value is TypedCookie<Schema>;
